#include <allegro.h>

#include "actor.h"
#include "sectors.h"
#include "draw.h"
#include "man.h"
#include "alienship.h"

ACTOR mothership;

float mothership0_points[] = {
	   -79.390,     22.683, // 0
	   -55.000,    -40.000, // 1
	    49.000,    -40.000, // 2
	    79.390,     11.341, // 3
	   170.121,     22.683, // 4
	   204.146,    -34.024, // 5
	   294.877,     56.707, // 6
	   306.219,    124.756, // 7
	  -147.439,     68.049, // 8
	  -215.487,     34.024, // 9
	  -340.243,     68.049, // 10
	  -328.902,    136.097, // 11
	  -761.302,    375.708, // 12
	   741.528,    405.369, // 13
	   919.495,    959.043, // 14
	     0.000,   1433.622, // 15
	  -454.804,    988.705, // 16
	  -669.145,    816.583, // 17
	  -603.110,    642.658, // 18
	  -237.289,    632.771, // 19
	  -204.146,    861.949, // 20
	   286.724,   1067.801, // 21
	   476.340,    907.315, // 22
	   435.030,    652.545, // 23
	    98.870,    642.658, // 24
	     0.000,    929.997, // 25
	  -840.399,   1077.688  // 26
};
int mothership0_lines[] = {
	0, 1, 255, 255, 0,
	1, 2, 255, 255, 0,
	2, 3, 255, 255, 0,
	3, 4, 255, 255, 0,
	4, 5, 255, 255, 0,
	5, 6, 255, 255, 0,
	6, 7, 255, 255, 0,
	9, 8, 255, 255, 0,
	8, 0, 255, 255, 0,
	10, 9, 255, 255, 0,
	11, 10, 255, 255, 0,
	15, 14, 0, 252, 192,
	15, 26, 0, 252, 192,
	26, 12, 0, 192, 112,
	14, 13, 0, 192, 112,
	13, 7, 0, 148, 56,
	12, 11, 0, 148, 56,
	16, 17, 252, 156, 56,
	16, 20, 252, 156, 56,
	21, 25, 252, 156, 56,
	21, 22, 252, 156, 56,
	24, 25, 252, 156, 56,
	24, 23, 252, 156, 56,
	19, 20, 252, 156, 56,
	19, 18, 252, 156, 56,
	18, 17, 252, 156, 56,
	23, 22, 252, 156, 56 
};
float mothership1_points[] = {
	   -79.390,     22.683, // 0
	   -55.000,    -40.000, // 1
	    49.000,    -40.000, // 2
	    79.390,     11.341, // 3
	   170.121,     22.683, // 4
	   204.146,    -34.024, // 5
	   294.877,     56.707, // 6
	   306.219,    124.756, // 7
	  -147.439,     68.049, // 8
	  -215.487,     34.024, // 9
	  -340.243,     68.049, // 10
	  -328.902,    136.097, // 11
	  -761.302,    375.708, // 12
	   741.528,    405.369, // 13
	   919.495,    959.043, // 14
	     0.000,   1433.622, // 15
	  -213.980,    972.031, // 16
	  -502.623,   1032.384, // 17
	  -590.821,    853.142, // 18
	  -354.154,    583.667, // 19
	  -151.513,    696.511, // 20
	   449.183,    930.561, // 21
	   498.713,    718.856, // 22
	   303.433,    553.979, // 23
	    48.227,    761.318, // 24
	   158.054,   1001.253, // 25
	  -840.399,   1077.688  // 26
};
int mothership1_lines[] = {
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	5, 6, 0, 0, 0,
	6, 7, 0, 0, 0,
	9, 8, 0, 0, 0,
	8, 0, 0, 0, 0,
	10, 9, 0, 0, 0,
	11, 10, 0, 0, 0,
	15, 14, 0, 252, 192,
	15, 26, 0, 252, 192,
	26, 12, 0, 192, 112,
	14, 13, 0, 192, 112,
	13, 7, 0, 148, 56,
	12, 11, 0, 148, 56,
	16, 17, 252, 255, 156,
	16, 20, 252, 255, 156,
	21, 25, 252, 255, 156,
	21, 22, 252, 255, 156,
	24, 25, 252, 255, 156,
	24, 23, 252, 255, 156,
	19, 20, 252, 255, 156,
	19, 18, 252, 255, 156,
	18, 17, 252, 255, 156,
	23, 22, 252, 255, 156 
};


void mothership_process(void)
{
	ACTOR *actor = &mothership;
	actor->anim++;
	if (actor->anim == 64) {
		actor->anim = 0;
		actor->frame++;
		if (actor->frame == 2) actor->frame = 0;
	}
}

static void mothership_draw(ACTOR *actor, int x, int y)
{
	if (actor->frame == 0) draw_(x, y, points(mothership0), lines(mothership0), mothership0_points, mothership1_points, mothership0_lines, actor->anim / 64.0);
	if (actor->frame == 1) draw_(x, y, points(mothership1), lines(mothership1), mothership1_points, mothership0_points, mothership1_lines, actor->anim / 64.0);
}

ACTOR *mothership_init(void)
{
	ACTOR *actor = &mothership;
	actor_init(actor);
	bound_(points(mothership0), mothership0_points, &(actor->l), &actor->t, &actor->r, &actor->b);
	actor->draw = mothership_draw;
	color_(lines(mothership0), mothership0_lines);
	color_(lines(mothership1), mothership1_lines);
	return actor;
}
